//***************************************************************************

// Copyright (C) 2009 Realmac Software Ltd
//
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information of Realmac Software Ltd
// and are protected by copyright law. They may not be disclosed
// to third parties or copied or duplicated in any form, in whole or
// in part, without the prior written consent of Realmac Software Ltd.

// Created by Keith Duncan on 19/06/2009

//***************************************************************************

#import <TargetConditionals.h>

#import <Foundation/Foundation.h>

#pragma mark - Binding Info Keys

extern NSString *AFObservedKeyPathKey;
extern NSString *AFObservedObjectKey;
extern NSString *AFOptionsKey;

/*!
	\brief
	This constant stores the current value of an unbound binding.
 */
extern NSString *const AFUnboundValueKey;

#pragma mark - Binding Names

/*!
	\brief
	Singular content object
 */
extern NSString *AFContentObjectBinding;

/*!
	\brief
	A singular version of NSSelectionIndexPathsBinding. Readwrite binding.
 */
extern NSString *const AFSelectionIndexPathBinding;

#pragma mark - Binding Options

extern NSString *AFValueTransformerNameBindingOption;
extern NSString *AFValueTransformerBindingOption;

/*
	\brief
	If the bool value is true, the -valueForBinding: will transform each object in the collection using the specified value transformer.
 */
extern NSString *const AFTransformIndividuallyWithArrayObjectsBindingOption;

#pragma mark - Key Value Binding Extensions

/*!
	\brief
	This is to be implemented by adopters.
 */
@protocol AFKeyValueBinding <NSObject>

- (id)infoForBinding:(NSString *)binding;
- (void)setInfo:(id)info forBinding:(NSString *)binding;

- (void *)contextForBinding:(NSString *)binding;

@end

/*!
	\brief
	The methods in this category are implemented on NSObject and require AFKeyValueBinding.
 */
@interface NSObject (AFKeyValueBindingAdditions)

/*!
	\brief
	This method will run the value through a value transformer if one is provided.
	It will retrieve an unbound value from the <tt>-infoForBinding:</tt> dictionary under the AFUnboundValueKey if the controller object is nil.
 */
- (id)valueForBinding:(NSString *)binding;

/*!
	\brief
	This method will reverse the value through a value transformer if one is provided.
	It will store the value in the <tt>-infoForBinding:</tt> dictionary under the AFUnboundValueKey if the controller object is nil.
 */
- (void)setValue:(id)value forBinding:(NSString *)binding;

/*!
	\return
	From the <tt>-infoForBinding:</tt> dictionary, the <tt>-objectForKey:</tt> NSObservedObjectKey.
 */
- (id)controllerForBinding:(NSString *)binding;

/*!
	\return
	From the <tt>-infoForBinding:</tt> dictionary, the <tt>-objectForKey:</tt> NSObservedKeyPathKey.
 */
- (NSString *)keyPathForBinding:(NSString *)binding;

/*!
	\brief
	This method first checks the NSValueTransformerBindingOption key for a provided instance,
	secondly it attempts to retrieve one from <tt>+[NSValueTransformer valueTransformerForName:]</tt>
	using NSValueTransformerNameBindingOption. If neither succeed it returns nil.
	
	\return
	The value transformer specified in the NSOptionsKey for the binding.
 */
- (NSValueTransformer *)valueTransformerForBinding:(NSString *)binding;

@end

/*!
	\brief
	The methods in this category are implemented on NSObject and require AFKeyValueBinding.
 */
@interface NSObject (RMKeyValueBinding)

- (id)mutableArrayValueForBinding:(NSString *)binding;

@end
